<?php

defined('PF_VERSION') OR exit('Access denied');
define('PLUGIN_POST', __('Posts', 'post'));

class Post_Plugin extends Pf_Plugin
{

    public $name = PLUGIN_POST;
    public $version = '1.0';
    public $author = 'PageFlex Team';
    public $description = 'This is the Post description';

    public function activate()
    {
        $db = Pf::database();
        $sql = "DROP TABLE IF EXISTS `pf_categories`,`pf_posts`, `pf_tags`, `pf_post_tags`;";
        $db->query($sql);
        $db->query("CREATE TABLE `pf_categories` (
                    `id` int(11) NOT NULL AUTO_INCREMENT,
                    `category_name` varchar(255) DEFAULT NULL,
                    `category_type` int(11) NOT NULL,
                    `category_parent` int(11) NOT NULL,
                    `category_author` int(11) NOT NULL,
                    `category_description` varchar(255) DEFAULT NULL,
                    `category_created_date` datetime NOT NULL,
                    `category_modified_date` datetime NOT NULL,
                    `category_status` tinyint(1) NOT NULL,
                    PRIMARY KEY (`id`)
                   ) ENGINE=InnoDB DEFAULT CHARSET=utf8 ;");

        $db->query("CREATE TABLE `pf_posts` (
                    `id` bigint(20) NOT NULL AUTO_INCREMENT,
                    `post_title` varchar(255) NOT NULL,
                    `post_author` int(11) NOT NULL,
                    `post_category` int(11) NOT NULL,
                    `post_thumbnail` varchar(500) DEFAULT NULL,
                    `post_created_date` datetime NOT NULL,
                    `post_modified_date` datetime NOT NULL,
                    `post_content` longtext NOT NULL,
                    `post_published_date` datetime DEFAULT NULL,
                    `post_unpublished_date` datetime DEFAULT NULL,
                    `post_views` int(11) DEFAULT '1',
                    `post_status` tinyint(1) NOT NULL,
                    PRIMARY KEY (`id`)
                   ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 ;");

        $db->query("CREATE TABLE IF NOT EXISTS `pf_tags` (
                    `id` bigint(20) NOT NULL AUTO_INCREMENT,
                    `tag_name` varchar(255) NOT NULL,
                    PRIMARY KEY (`id`)
                  ) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");

        $db->query("CREATE TABLE IF NOT EXISTS `pf_post_tags` (
                    `id` bigint(20) NOT NULL AUTO_INCREMENT,
                    `post_tag_post_id` bigint(20) NOT NULL,
                    `post_tag_tag_id` bigint(20) NOT NULL,
                    PRIMARY KEY (`id`)
                  ) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");
    }

    public function deactivate()
    {
        $db = Pf::database();
        $sql = "DROP TABLE IF EXISTS `pf_categories`,`pf_posts`, `pf_tags`, `pf_post_tags`;";
        $db->query($sql);
    }

    public function admin_init()
    {
        require_once ABSPATH . '/includes/common/plugin/utiles/pf-plugin-singleton.php';
        require_once abs_plugin_path(__FILE__) . '/post/post-config.php';
        require_once ABSPATH . '/includes/common/libs/category/pf-lib-category.php';
        require ABSPATH . '/includes/common/plugin/helpers/permission.php';
        if (plugin_check_acl(array(1, 2, 3, 4))) {
            $this->admin_menu('fa fa-edit', __('Posts', 'post'), 'post', 'plugin_post_manager');
            $this->admin_children_menu('fa fa-angle-double-right', __('Posts', 'post'), 'post', 'plugin_post_manager', 'Post');
        }

        if (plugin_check_acl(array(1, 2))) {
            $this->admin_children_menu('fa fa-angle-double-right', __('Category', 'post'), 'category', 'plugin_post_manager', 'Post');
        }
    }

    function plugin_post_manager()
    {
        $this->js('admin/themes/default/assets/bootstrap-notification/js/jquery/jquery.easing.1.3.js');
        $this->js('admin/themes/default/assets/bootstrap-notification/js/bootstrap.notification.js');

        $this->js('admin/themes/default/assets/tinymce/js/tinymce/tinymce.min.js');
        $this->css('post/assets/post.css', __FILE__);
        $this->js('post/assets/bootbox.min.js', __FILE__);

        //Fancy box
        $this->js('admin/plugins/media/assets/fancybox/jquery.fancybox-1.3.6.pack.js');
        $this->css('admin/plugins/media/assets/fancybox/jquery.fancybox-1.3.6.css');

        //Datetimepicker
        $this->js('post/assets/moment.js', __FILE__);
        $this->js('post/assets/bootstrap-datetimepicker.js', __FILE__);
        $this->css('post/assets/bootstrap-datetimepicker.css', __FILE__);

        //tagsinput
        $this->css('post/assets/bootstrap-tagsinput.css', __FILE__);
        $this->js('post/assets/bootstrap-tagsinput.min.js', __FILE__);

        $this->js('includes/common/plugin/assets/base.js');
        $this->js('post/assets/post.js?t=' . uniqid(), __FILE__);
        require_once abs_plugin_path(__FILE__) . '/post/index.php';
    }

    function public_init()
    {
        $shortcode = Pf::shortcode();
        $shortcode->add('post', array($this, 'plugin_post_public'));
        $shortcode->add('posts', array($this, 'plugin_posts_public'));
    }

    function plugin_post_public($atts, $content = null, $code = '')
    {
        $output = require abs_plugin_path(__FILE__) . '/post/public/post.php';
        return $output;
    }

    function plugin_posts_public($atts, $content = null, $code = '')
    {
        $output = require abs_plugin_path(__FILE__) . '/post/public/posts.php';
        return $output;
    }

}
